//----------------------------------------------------------------------------//
//- CadBaseDialog.pas --------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Abstrakte Basisklasse TDlgBaseDialog                                       //
//                                                                            //
// Diese Klasse kapselt ein Formular mit allen Eigenschaften, die bei allen   //
// Dialogen gleich sind.                                                      //
// Alle Dialoge werden von hier abgeleitet                                    //
// Dialog darf nicht instanziert werden, aus diesem Grund existiert keine     //
// globale Variable DlgBaseDialog.                                            //
//----------------------------------------------------------------------------//

unit CadBaseDialog;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CaoCheck;

//------------------------------------------------------------------------------

type
  TCaDlgBaseDialog = class(TForm)
    m_BtnOk         : TButton;
    m_BtnAbbrechen  : TButton;

    //--------------------------------------------------------------------------

    procedure FormCloseQuery  (Sender: TObject; var CanClose: Boolean);
    procedure FormCreate      (Sender: TObject);
    procedure FormDestroy     (Sender: TObject);

  //----------------------------------------------------------------------------

  private

  //----------------------------------------------------------------------------

  protected
    m_obCaoCheck : TCaoCheck;

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------

  end; // TCaDlgBaseDialog

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaDlgBaseDialog.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
(*
  Soll der Dialog mit OK verlassen werden, wird erst berprft, ob alle Muss-
  Eingaben gemacht wurden.
*)
begin
  CanClose := True;
  // Prfen, ob der Dialog mit "OK" oder "Weitere erfassen" verlassen wird 
  if (ModalResult = mrOk) or (ModalResult = mrRetry) then begin
    CanClose := m_obCaoCheck.CheckFormData(Self);
  end; // if
end; // TCaDlgBaseDialog.FormCloseQuery

//------------------------------------------------------------------------------

procedure TCaDlgBaseDialog.FormCreate(Sender: TObject);
begin
  m_obCaoCheck := TCaoCheck.Create;
end; // TCaDlgBaseDialog.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgBaseDialog.FormDestroy(Sender: TObject);
begin
  m_obCaoCheck.Free
end; // TCaDlgBaseDialog.FormDestroy

//------------------------------------------------------------------------------

end. // CadBaseDialog
